//
//  ServiceProvider.swift
//  TopShelf
//
//  Created by Christian Leonhard Corsten on 27.01.16.
//  Copyright © 2016 Christian Corsten. All rights reserved.
//

import Foundation
import TVServices

class ServiceProvider: NSObject, TVTopShelfProvider {

    override init() {
        super.init()
    }

    // MARK: - TVTopShelfProvider protocol

    var topShelfStyle: TVTopShelfContentStyle {
        // Return desired Top Shelf style.
        return .Sectioned
    }

    var topShelfItems: [TVContentItem] {
        // Create an array of TVContentItems.
        
        let wrapperID = TVContentIdentifier(identifier: "shelf-wrapper", container: nil)!
        let wrapperItem = TVContentItem(contentIdentifier: wrapperID)!
        
        var contentItems = [TVContentItem]()
        
        let identifier = TVContentIdentifier(identifier: "VOD", container: wrapperID)!
        
        let urlPath = NSBundle.mainBundle().pathForResource("TopShelf", ofType: "png")
        let url: NSURL = NSURL.fileURLWithPath(urlPath!)

        let contentItem = TVContentItem(contentIdentifier: identifier)!
        
        contentItem.imageURL = url
        contentItem.imageShape = .HDTV
        contentItem.title = "Rubbeldiekatz"
        contentItem.displayURL = NSURL(string: "VideoApp://video/1")
        contentItem.playURL = NSURL(string: "VideoApp://video/1")
        
        contentItems.append(contentItem)
        
        wrapperItem.title = "Available Movies"
        wrapperItem.topShelfItems = contentItems
        
        return [wrapperItem]
    }

}

